
#include "dvlbutton.h"

#include <linux/autoconf.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/timer.h>
#include <linux/cdev.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/kdev_t.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/types.h>

#include <asm/uaccess.h>

#ifdef _DVL_ENABLE_BUTTON_MAPPING
#include <linux/kernel.h>
#include <linux/device.h>

#define MAX_KEY_VALUE_SIZE 32

//Maximum buffersize for button mapping file
#define SYSFS_MAX_SIZE		1024
#if SYSFS_MAX_SIZE > PAGE_SIZE
#undef SYSFS_MAX_SIZE
#define SYSFS_MAX_SIZE PAGE_SIZE
#warning "SYSFS_MAX_SIZE is restricted to PAGE_SIZE"
#endif

//depends on platform
extern char valid_button_char[];

//depends on platform
extern char *valid_buttons[];

//keys that can be modified, take a look at dvlbutton_entry_t
static char *valid_keys[] = {"c1","c2","param1","param2",NULL};

#endif

#define NO_MULTI_CONNECTION		-1


struct dvlbutton_dev {
    wait_queue_head_t inq;    /* read queue */
    struct semaphore sem;
    struct cdev cdev;         /* character device */
};

typedef enum {
	TYPE_NONE = 0,
	TYPE_BUTTON,
	TYPE_BUTTON_TWOWAY,
	TYPE_BUTTON_SHORTLONG,
	TYPE_SWITCH,
    TYPE_MULTIBUTTON_SIMPLE,                // Multibuttons are pairs that can be pressed simultaneously
    TYPE_MULTIBUTTON_SHORTLONG,
} button_type_t;

/**
 * to mark a button/gpio as high or low active
 */
typedef enum {
	POL_UNDEF = 0, //just for the sake of tidyness
	POL_HA = 0,
	POL_LA = 1 //for compatibility reasons POL_LA has to be 1
} polarity_t;

/**
 * to mark a button/gpio as edge or level sensitive
 */
typedef enum {
    SENSE_UNDEF = 0,
    SENSE_EDGE = 0, //interrupt on a to be configured edge (falling or rising)
    SENSE_LEVEL = 1 //interrupt on reaching a to be configured level (high or low)
} sensitivity_t;

typedef struct {
    char *name;
    button_type_t type;
    int connected_button_nr;       // MULTIBUTTON - this is the nr of the other one or NO_MULTI_CONNECTION  
	char c1;
	char c2;
    char c3;
	int gpio;
	int irq;
	polarity_t polarity;
	sensitivity_t sensitivity;
	int param1;  // TYPE_BUTTON_SHORTLONG/MULTIBUTTON: short duration
	int param2;  // TYPE_BUTTON_SHORTLONG/MULTIBUTTON: long duration
    int param3;  // TYPE_MULTIBUTTON_SHORTLONG/TYPE_MULTIBUTTON_SIMPLE: simultaneous press duration
} dvlbutton_entry_t;

struct dvlbutton_context {
	int last_change;
	struct timespec last_time;          // debounce and short press time
    bool is_pressed;
    bool has_event;
	struct timer_list timer;
    struct timer_list multitimer;
	struct dvlbutton_dev *dev;
};

extern dvlbutton_entry_t global_buttons[];
extern struct dvlbutton_context *global_contexts;

void dvl_gpio_line_config_in(dvlbutton_entry_t *button);
void dvl_gpio_line_get(int line, int *value);
void dvl_gpio_change_get(int irq, int *button, int *change);
void dvl_gpio_clear(void);

void dvl_gpio_init(void);
void dvl_gpio_shutdown(void);

